<?php $__env->startSection('content'); ?>
<div class="container">
    <h2 class="mb-4">Admin Dashboard</h2>

    
    <form method="GET" action="<?php echo e(route('dashboard')); ?>" class="card p-3 mb-4">
        <div class="row g-3">

            <div class="col-md-3">
                <label class="form-label">From Date</label>
                <input type="date" name="from" class="form-control" value="<?php echo e(request('from')); ?>">
            </div>

            <div class="col-md-3">
                <label class="form-label">To Date</label>
                <input type="date" name="to" class="form-control" value="<?php echo e(request('to')); ?>">
            </div>

            <div class="col-md-3">
                <label class="form-label">Dealer</label>
                <select name="dealer_id" class="form-select">
                    <option value="">All Dealers</option>
                    <?php $__currentLoopData = $dealerStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dealer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($dealer->id); ?>" <?php echo e(request('dealer_id') == $dealer->id ? 'selected' : ''); ?>>
                            <?php echo e($dealer->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="col-md-3">
                <label class="form-label">Model</label>
                <select name="model" class="form-select">
                    <option value="">All Models</option>
                    <?php $__currentLoopData = $modelCounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($model->model); ?>" <?php echo e(request('model') == $model->model ? 'selected' : ''); ?>>
                            <?php echo e($model->model); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="col-md-3">
                <label class="form-label">Province</label>
                <select name="province" class="form-select">
                    <option value="">All Provinces</option>
                    <?php $__currentLoopData = $provinceActivations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $province): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($province->province); ?>" <?php echo e(request('province') == $province->province ? 'selected' : ''); ?>>
                            <?php echo e($province->province); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="col-md-3 align-self-end">
                <button class="btn btn-primary w-100">Apply Filters</button>
            </div>

            <div class="col-md-3 align-self-end">
                <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-secondary w-100">Reset</a>
            </div>

        </div>
    </form>

    
    <div class="row mb-4">
        <div class="col-md-3"><div class="card p-3 text-center"><h6>Total Devices</h6><strong><?php echo e($totalDevices); ?></strong></div></div>
        <div class="col-md-3"><div class="card p-3 text-center"><h6>Allocated but Not Activated</h6><strong><?php echo e($allocatedDevices); ?></strong></div></div>
        <div class="col-md-3"><div class="card p-3 text-center"><h6>Activated</h6><strong><?php echo e($activatedDevices); ?></strong></div></div>
        <div class="col-md-3"><div class="card p-3 text-center"><h6>In Stock</h6><strong><?php echo e($inStockDevices); ?></strong></div></div>
    </div>

    <h4>Dealer-wise Allocation vs Activation</h4>
    <canvas id="dealerChart" style="min-height:300px"></canvas>

    <h4 class="mt-5">Activated Devices by Province</h4>
    <canvas id="provinceChart" style="min-height:300px"></canvas>

    <h4 class="mt-5">Model Distribution</h4>
    <canvas id="modelChart" style="min-height:300px"></canvas>

    <h4 class="mt-5">Activation Timeline</h4>
    <canvas id="timelineChart" style="min-height:300px"></canvas>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function () {

    // Dealer-wise Allocation vs Activation
    new Chart(document.getElementById('dealerChart'), {
        type: 'bar',
        data: {
            labels: <?php echo json_encode($dealerStats->pluck('name'), 15, 512) ?>,
            datasets: [
                {
                    label: 'Allocated',
                    data: <?php echo json_encode($dealerStats->pluck('allocated_count'), 15, 512) ?>,
                },
                {
                    label: 'Activated',
                    data: <?php echo json_encode($dealerStats->pluck('activated_count'), 15, 512) ?>,
                }
            ]
        },
        options: { responsive: true, scales: { y: { beginAtZero: true } } }
    });

    // Province-wise Activation
    new Chart(document.getElementById('provinceChart'), {
        type: 'bar',
        data: {
            labels: <?php echo json_encode($provinceActivations->pluck('province'), 15, 512) ?>,
            datasets: [{
                label: 'Activated',
                data: <?php echo json_encode($provinceActivations->pluck('total'), 15, 512) ?>,
            }]
        },
        options: { responsive: true, scales: { y: { beginAtZero: true } } }
    });

    // Model Distribution
    new Chart(document.getElementById('modelChart'), {
        type: 'pie',
        data: {
            labels: <?php echo json_encode($modelCounts->pluck('model'), 15, 512) ?>,
            datasets: [{
                data: <?php echo json_encode($modelCounts->pluck('total'), 15, 512) ?>,
            }]
        },
        options: { responsive: true }
    });

    // Activation Timeline
    new Chart(document.getElementById('timelineChart'), {
        type: 'line',
        data: {
            labels: <?php echo json_encode($activationTimeline->pluck('date'), 15, 512) ?>,
            datasets: [{
                label: 'Activations',
                data: <?php echo json_encode($activationTimeline->pluck('total'), 15, 512) ?>,
                tension: 0.3,
                fill: false
            }]
        },
        options: { responsive: true, scales: { y: { beginAtZero: true } } }
    });

});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/soumadeep/Desktop/imei-saas/resources/views/dashboard/admin.blade.php ENDPATH**/ ?>