<?php $__env->startSection('content'); ?>
<div class="container">
    <h3>Upload Sales to Dealer File</h3>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <?php echo e($errors->first()); ?>

        </div>
    <?php endif; ?>

    <form
        id="uploadForm"
        method="POST"
        action="<?php echo e(route('imports.allocation.upload')); ?>"
        enctype="multipart/form-data"
    >
        <?php echo csrf_field(); ?>

        <div class="mb-3">
            <label class="form-label">Excel File</label>
            <input
                type="file"
                name="file"
                class="form-control"
                accept=".xlsx,.xls,.csv"
                required
            >
        </div>

        
        <div class="progress mb-3 d-none" id="progressWrapper">
            <div
                class="progress-bar progress-bar-striped progress-bar-animated"
                id="progressBar"
                role="progressbar"
                style="width: 0%"
            >
                0%
            </div>
        </div>

        <button type="submit" class="btn btn-warning" id="submitBtn">
            Upload
        </button>
    </form>

    <p class="mt-3 text-muted">
        Dealer name in the Excel file must exactly match an existing dealer record.
    </p>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.getElementById('uploadForm').addEventListener('submit', function (e) {
    e.preventDefault();

    const form = this;
    const formData = new FormData(form);

    const progressWrapper = document.getElementById('progressWrapper');
    const progressBar = document.getElementById('progressBar');
    const submitBtn = document.getElementById('submitBtn');

    progressWrapper.classList.remove('d-none');
    submitBtn.disabled = true;

    const xhr = new XMLHttpRequest();
    xhr.open('POST', form.action, true);
    xhr.setRequestHeader('X-CSRF-TOKEN', '<?php echo e(csrf_token()); ?>');

    xhr.upload.addEventListener('progress', function (e) {
        if (e.lengthComputable) {
            const percent = Math.round((e.loaded / e.total) * 100);
            progressBar.style.width = percent + '%';
            progressBar.innerText = percent + '%';
        }
    });

    xhr.onload = function () {
        if (xhr.status === 200) {
            progressBar.classList.remove('progress-bar-animated');
            progressBar.classList.add('bg-success');
            progressBar.innerText = 'Upload Complete';

            // Controller redirects to progress view
            window.location.href = xhr.responseURL;
        } else {
            progressBar.classList.add('bg-danger');
            progressBar.innerText = 'Upload Failed';
            submitBtn.disabled = false;
        }
    };

    xhr.onerror = function () {
        progressBar.classList.add('bg-danger');
        progressBar.innerText = 'Error';
        submitBtn.disabled = false;
    };

    xhr.send(formData);
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/soumadeep/Desktop/imei-saas/resources/views/imports/allocation.blade.php ENDPATH**/ ?>